precision mediump float;

//declare uniforms
uniform sampler2D u_diffuseTexture;
uniform sampler2D _DisplacementTex;
uniform float _DisplacementPowerX;
uniform float _DisplacementPowerY;
uniform vec2 _textureSize;
uniform vec2 _texelSize;

//"in" attributes from our vertex shader
varying vec4 v_color;
varying vec2 v_texCoords;

void main() {
//	vec4 mapColor = texture2D(_DisplacementTex, v_texCoords);
//	vec2 displacement = vec2(vec2(_DisplacementPowerX, _DisplacementPowerY) * ((mapColor.g - 0.5) * 2.0));
//	gl_FragColor = texture2D(u_diffuseTexture, v_texCoords + displacement);
//	if(gl_FragColor.a == 0.0){discard;}

	float factorX = _DisplacementPowerX * _texelSize.x;
	float factorY = _DisplacementPowerY * _texelSize.y;

//	vec2 depthCoords = v_texCoords;
//	depthCoords.x = depthCoords.x - factorX;
//	depthCoords.y = depthCoords.y - factorY;
	vec4 targetMaskValue = texture2D(_DisplacementTex, v_texCoords);

	vec2 uvDisplaced = v_texCoords;
	uvDisplaced.x = uvDisplaced.x - factorX * targetMaskValue.g; //((targetMaskValue.x - 0.5) * 2.0);
	uvDisplaced.y = uvDisplaced.y - factorY * targetMaskValue.g; //((targetMaskValue.y - 0.5) * 2.0);

	vec4 imageColor = texture2D(u_diffuseTexture, uvDisplaced);

	gl_FragColor = imageColor;
}